/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.skills.core;

import com.google.gson.JsonElement;
import dev.toma.gunsrpg.api.common.skill.IDataResolver;
import dev.toma.gunsrpg.api.common.skill.ITransactionValidator;
import dev.toma.gunsrpg.api.common.skill.ITransactionValidatorFactory;
import dev.toma.gunsrpg.common.skills.core.PlayerLevelTransactionValidator;
import dev.toma.gunsrpg.common.skills.core.PlayerLevelTransactionValidatorFactory;
import dev.toma.gunsrpg.common.skills.core.WeaponLevelTransactionValidatorFactory;
import dev.toma.gunsrpg.common.skills.core.WeaponTransactionValidator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;

public final class TransactionValidatorRegistry {
    private static final Map<ResourceLocation, ITransactionValidatorFactory<?, ?>> TYPE_FACTORY_MAP = new HashMap();
    private static final Map<ITransactionValidatorFactory<?, ?>, Set<ITransactionValidator>> TYPE_VALIDATORS = new IdentityHashMap();

    public static <F extends ITransactionValidatorFactory<?, ?>> F getValidatorFactory(ResourceLocation location) {
        return (F)TYPE_FACTORY_MAP.get(location);
    }

    public static <T extends ITransactionValidator> Set<T> getRegisteredValidators(ITransactionValidatorFactory<T, ?> factory) {
        return TYPE_VALIDATORS.computeIfAbsent(factory, key -> new HashSet());
    }

    public static <T extends ITransactionValidator, D> T getTransactionValidator(ITransactionValidatorFactory<T, D> factory, JsonElement jsonData) {
        Set<ITransactionValidator> set = TransactionValidatorRegistry.getRegisteredValidators(factory);
        IDataResolver<D> dataResolver = factory.resolver();
        ITransactionValidator handler = null;
        D data = dataResolver.resolve(jsonData);
        for (ITransactionValidator t : set) {
            if (!factory.isDataMatch(t, data)) continue;
            handler = t;
            break;
        }
        if (handler == null) {
            handler = factory.createFor(data);
            set.add(handler);
        }
        return (T)handler;
    }

    public static void registerValidatorFactory(ResourceLocation key, ITransactionValidatorFactory<?, ?> factory) {
        TYPE_FACTORY_MAP.put(key, factory);
    }

    public static Set<ResourceLocation> getRegisteredValidatorTypes() {
        return TYPE_FACTORY_MAP.keySet();
    }

    static {
        TransactionValidatorRegistry.registerValidatorFactory(PlayerLevelTransactionValidator.ID, new PlayerLevelTransactionValidatorFactory());
        TransactionValidatorRegistry.registerValidatorFactory(WeaponTransactionValidator.ID, new WeaponLevelTransactionValidatorFactory());
    }
}

